/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.glassfish.grizzly.asyncqueue.WritableMessage;

public class FileTransfer
implements WritableMessage {
    private FileChannel fileChannel;
    private long len;
    private long pos;

    public FileTransfer(File f2) {
        this(f2, 0L, f2.length());
    }

    public FileTransfer(File f2, long pos, long len) {
        if (f2 == null) {
            throw new IllegalArgumentException("f cannot be null.");
        }
        if (!f2.exists()) {
            throw new IllegalArgumentException("File " + f2.getAbsolutePath() + " does not exist.");
        }
        if (!f2.canRead()) {
            throw new IllegalArgumentException("File " + f2.getAbsolutePath() + " is not readable.");
        }
        if (f2.isDirectory()) {
            throw new IllegalArgumentException("File " + f2.getAbsolutePath() + " is a directory.");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("The pos argument cannot be negative.");
        }
        if (len < 0L) {
            throw new IllegalArgumentException("The len argument cannot be negative.");
        }
        if (pos > f2.length()) {
            throw new IllegalArgumentException("Illegal offset");
        }
        if (f2.length() - pos < len) {
            throw new IllegalArgumentException("Specified length exceeds available bytes to transfer.");
        }
        this.pos = pos;
        this.len = len;
        try {
            this.fileChannel = new FileInputStream(f2).getChannel();
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException(fnfe);
        }
    }

    public long writeTo(WritableByteChannel c) throws IOException {
        long written = this.fileChannel.transferTo(this.pos, this.len, c);
        this.pos += written;
        this.len -= written;
        return written;
    }

    @Override
    public boolean hasRemaining() {
        return this.len != 0L;
    }

    @Override
    public int remaining() {
        return this.len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() {
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.fileChannel = null;
        }
        return true;
    }

    @Override
    public boolean isExternal() {
        return true;
    }
}

